<?php
// includes/mailer.php

// -----------------------------------------------------------------------------
// IMPRESCINDIBLE: NO MODIFICAR ESTAS LÍNEAS
// Estas líneas importan las clases de PHPMailer que instalaste con Composer.
// -----------------------------------------------------------------------------
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

// -----------------------------------------------------------------------------
// IMPRESCINDIBLE: NO MODIFICAR ESTAS LÍNEAS
// Esta es la línea "mágica" que carga automáticamente PHPMailer.
// Funciona porque la carpeta 'vendor' está en el directorio raíz de tu proyecto.
// -----------------------------------------------------------------------------
require_once __DIR__ . '/../vendor/autoload.php';

// -----------------------------------------------------------------------------
// CARGA DE CONFIGURACIÓN
// Incluimos nuestras credenciales de correo desde el archivo de configuración.
// -----------------------------------------------------------------------------
require_once __DIR__ . '/../config/mail_config.php';


/**
 * Función para enviar un correo electrónico usando PHPMailer.
 *
 * @param string $destinatario_email La dirección de correo del destinatario.
 * @param string $destinatario_nombre El nombre del destinatario.
 * @param string $asunto El asunto del correo.
 * @param string $cuerpo El contenido HTML del correo.
 * @return bool Devuelve TRUE si el correo se envió correctamente, FALSE en caso de error.
 */
function enviarEmail($destinatario_email, $destinatario_nombre, $asunto, $cuerpo) {
    
    // Creamos una nueva instancia de PHPMailer. El 'true' activa las excepciones en caso de error.
    $mail = new PHPMailer(true);

    try {
        // --- 1. Configuración del Servidor SMTP ---
        $mail->SMTPDebug = SMTP::DEBUG_SERVER;  // Descomenta esta línea si necesitas ver el log detallado de la conexión.
        $mail->isSMTP();                          // Usar el protocolo SMTP.
        $mail->Host       = SMTP_HOST;            // El host de tu servidor SMTP (ej. 'sandbox.smtp.mailtrap.io').
        $mail->SMTPAuth   = true;                 // Habilitar la autenticación SMTP.
        $mail->Username   = SMTP_USERNAME;        // Tu usuario SMTP.
        $mail->Password   = SMTP_PASSWORD;        // Tu contraseña SMTP.
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // Habilitar encriptación TLS.
        $mail->Port       = SMTP_PORT;            // El puerto TCP para conectarse.

        // --- 2. Configuración de Remitente y Destinatario ---
        $mail->setFrom(MAIL_FROM_ADDRESS, MAIL_FROM_NAME);
        $mail->addAddress($destinatario_email, $destinatario_nombre); // Añadir el destinatario.

        // --- 3. Configuración del Contenido del Correo ---
        $mail->isHTML(true);                      // Indicar que el correo tendrá formato HTML.
        $mail->Subject = $asunto;                 // Asunto del correo.
        $mail->Body    = $cuerpo;                 // Cuerpo del correo en HTML.
        $mail->AltBody = strip_tags($cuerpo);     // Versión en texto plano para clientes de correo que no soportan HTML.
        $mail->CharSet = 'UTF-8';                 // Asegurar que los caracteres como tildes y eñes se vean bien.

        // --- 4. Enviar el Correo ---
        $mail->send();
        
        // Si llegamos hasta aquí, el correo se envió.
        return true;

    } catch (Exception $e) {
        // Si ocurre cualquier error durante el proceso, PHPMailer lanzará una excepción.
        // En un entorno de producción, es buena idea registrar este error en un archivo de log.
        error_log("Error al enviar email: {$mail->ErrorInfo}");
        
        // Devolvemos 'false' para indicar que el envío falló.
        return false;
    }
}
?> 