<?php
// confirmar.php

require_once 'config/db.php';

$mensaje = "";

if (isset($_GET['token']) && !empty($_GET['token'])) {
    $token = $_GET['token'];

    // Buscar el token en la base de datos
    $sql = "SELECT id, token_vencimiento FROM usuarios WHERE token_confirmacion = ? AND email_confirmado = FALSE";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 1) {
        $usuario = $resultado->fetch_assoc();
        $fecha_actual = date('Y-m-d H:i:s');

        // Verificar si el token no ha expirado
        if ($fecha_actual < $usuario['token_vencimiento']) {
            // El token es válido y no ha expirado, actualizamos el usuario
            $update_sql = "UPDATE usuarios SET email_confirmado = TRUE, token_confirmacion = NULL, token_vencimiento = NULL WHERE id = ?";
            $update_stmt = $mysqli->prepare($update_sql);
            $update_stmt->bind_param("i", $usuario['id']);
            if ($update_stmt->execute()) {
                $mensaje = "¡Tu cuenta ha sido confirmada exitosamente! Ya puedes iniciar sesión.";
            } else {
                $mensaje = "Hubo un error al confirmar tu cuenta. Por favor, intenta de nuevo.";
            }
            $update_stmt->close();
        } else {
            // El token ha expirado
            $mensaje = "El enlace de confirmación ha expirado. Por favor, solicita uno nuevo.";
        }
    } else {
        // El token no es válido o la cuenta ya fue confirmada
        $mensaje = "El enlace de confirmación no es válido o ya ha sido utilizado.";
    }

    $stmt->close();
} else {
    $mensaje = "Token no proporcionado.";
}

$mysqli->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Confirmación de Cuenta</title>
    <style>
        body { font-family: sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; background-color: #f4f4f4; }
        .container { text-align: center; padding: 40px; background: white; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        a { color: #007bff; text-decoration: none; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Confirmación de Cuenta</h1>
        <p><?php echo htmlspecialchars($mensaje); ?></p>
        <a href="login.html">Ir a Iniciar Sesión</a> <!-- Asumimos que tendrás un login.html -->
    </div>
</body>
</html>