<?php
// api/login.php

// Iniciar la sesión ANTES de cualquier salida HTML o de texto
session_start();

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once '../config/db.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->email) || empty($data->contrasena)) {
    http_response_code(400);
    echo json_encode(["mensaje" => "Email y contraseña son obligatorios."]);
    exit();
}

$email = $data->email;
$contrasena = $data->contrasena;

// Buscar el usuario por email
$sql = "SELECT id, nombre, contrasena, email_confirmado FROM usuarios WHERE email = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$resultado = $stmt->get_result();

if ($resultado->num_rows === 1) {
    $usuario = $resultado->fetch_assoc();

    // 1. Verificar si la cuenta está confirmada
    if (!$usuario['email_confirmado']) {
        http_response_code(403); // Forbidden
        echo json_encode(["mensaje" => "Tu cuenta no ha sido confirmada. Revisa tu email."]);
        exit();
    }

    // 2. Verificar la contraseña
    if (password_verify($contrasena, $usuario['contrasena'])) {
        // La contraseña es correcta, iniciamos la sesión
        $_SESSION['usuario_id'] = $usuario['id'];
        $_SESSION['usuario_nombre'] = $usuario['nombre'];

        http_response_code(200); // OK
        echo json_encode([
            "mensaje" => "Login exitoso.",
            "usuario" => [
                "id" => $usuario['id'],
                "nombre" => $usuario['nombre']
            ]
        ]);
    } else {
        // Contraseña incorrecta
        http_response_code(401); // Unauthorized
        echo json_encode(["mensaje" => "Credenciales incorrectas."]);
    }
} else {
    // Usuario no encontrado
    http_response_code(401); // Unauthorized
    echo json_encode(["mensaje" => "Credenciales incorrectas."]);
}

$stmt->close();
$mysqli->close();
?>